//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0

import wesual.data.Core 1.0

UiDelegate {
    id : author

    property DocumentRangeModel model

    property bool __wasSelected : false

    active : selected

    onPressed : {
        __wasSelected = model.isSelected(document);

        if (__wasSelected) {
            return;
        }

        forceActiveFocus();

        var shiftPressed = modifiers & Qt.ShiftModifier;
        var ctrlPressed  = modifiers & Qt.ControlModifier;

        if (shiftPressed && model.anchor) {
            model.selectRange(model.anchor, document);
        } else if (ctrlPressed) {
            model.select(document);
        } else {
            model.clearSelection();
            model.select(document);
            model.anchor = document;
        }
    }

    onClicked : {
        if (!__wasSelected)
            return;

        var shiftPressed = modifiers & Qt.ShiftModifier;
        var ctrlPressed  = modifiers & Qt.ControlModifier;

        if (shiftPressed && model.anchor) {
            model.selectRange(model.anchor, document);
        } else if (ctrlPressed) {
            model.deselect(document);
        } else {
            model.clearSelection();
            model.select(document);
        }
    }
}
